<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Results for "{{ $query }}" - {{ get_setting('site_title') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Mukta:wght@400;500;600;700&family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Roboto', sans-serif; background-color: #f8f9fa; }
        .hindi-text { font-family: 'Mukta', sans-serif; }
        /* Professional Search Gradient */
        .search-gradient { background: linear-gradient(135deg, #be123c 0%, #881337 100%); }
        .job-card { transition: all 0.3s ease; }
        .job-card:hover { transform: translateY(-3px); box-shadow: 0 10px 20px rgba(0,0,0,0.1); }

        /* AD PLACEHOLDER STYLE */
        .ad-slot {
            background-color: #e5e7eb;
            border: 2px dashed #9ca3af;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            width: 100%;
            margin-bottom: 1.5rem;
            overflow: hidden;
            text-align: center;
            font-size: 0.8rem;
        }
    </style>
</head>
<body class="bg-gray-50 flex flex-col min-h-screen">

    <nav class="bg-[#0f172a] text-white shadow-lg sticky top-0 z-50 border-b border-blue-900">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <a href="{{ route('home') }}" class="flex items-center gap-2 group">
                <div class="bg-white p-1 rounded-sm group-hover:rotate-3 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-blue-900" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M6 6V5a3 3 0 013-3h2a3 3 0 013 3v1h2a2 2 0 012 2v3.57A22.952 22.952 0 0110 13a22.95 22.95 0 01-8-1.43V8a2 2 0 012-2h2zm2-1a1 1 0 011-1h2a1 1 0 011 1v1H8V5zm1 5a1 1 0 011-1h.01a1 1 0 110 2H10a1 1 0 01-1-1z" clip-rule="evenodd" />
                    </svg>
                </div>
                <span class="text-2xl font-black uppercase text-yellow-400 tracking-tighter">
                    JOB <span class="text-white">UPDATE</span>
                </span>
            </a>
            <a href="{{ route('home') }}" class="text-sm font-bold bg-blue-600 px-4 py-2 rounded-lg hover:bg-blue-500 transition shadow-md flex items-center gap-1">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" /></svg>
                Home
            </a>
        </div>
    </nav>

    <div class="search-gradient text-white py-10 relative overflow-hidden shadow-md">
        <div class="absolute inset-0 opacity-10 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')]"></div>
        
        <div class="container mx-auto px-4 relative z-10 text-center">
            <div class="inline-flex items-center gap-2 text-red-200 text-sm mb-3 bg-white/10 px-3 py-1 rounded-full">
                <a href="{{ route('home') }}" class="hover:text-white">Home</a>
                <span>/</span>
                <span>Search</span>
            </div>
            <h1 class="text-3xl md:text-5xl font-extrabold uppercase tracking-wide drop-shadow-sm mb-2">
                Search Results
            </h1>
            <p class="text-red-100 text-lg">
                You searched for: <span class="bg-white/20 px-2 py-0.5 rounded font-bold text-white">"{{ $query }}"</span>
            </p>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-8">
        <div class="ad-slot h-24">
            📢 ADVERTISEMENT (Top Banner)
        </div>
    </div>

    <div class="container mx-auto px-4 py-4 flex-grow">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
            
            <div class="lg:col-span-3">

                <div class="ad-slot h-20 mb-6">
                    📢 ADVERTISEMENT (Sponsored Results)
                </div>

                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    
                    <div class="bg-gray-50 p-4 border-b border-gray-200 flex flex-wrap justify-between items-center gap-2">
                        <div class="flex items-center gap-2">
                            <span class="bg-red-100 text-red-800 text-xs font-bold px-2.5 py-0.5 rounded border border-red-200">
                                FOUND: {{ $posts->total() }}
                            </span>
                        </div>
                        <span class="text-xs text-gray-500 font-medium bg-white px-2 py-1 rounded border">
                            Page {{ $posts->currentPage() }} of {{ $posts->lastPage() }}
                        </span>
                    </div>

                    <div class="divide-y divide-gray-100">
                        @forelse($posts as $post)
                        <div class="job-card group relative p-5 bg-white hover:bg-red-50/30 transition-all border-l-4 border-transparent hover:border-red-600">
                            <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                                
                                <div class="flex-1">
                                    <div class="flex items-start gap-3">
                                        <div class="mt-1 hidden sm:block">
                                            @if($post->post_type == 'job')
                                                <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-bold">💼</div>
                                            @elseif($post->post_type == 'admit_card')
                                                <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center text-green-600 font-bold">👤</div>
                                            @elseif($post->post_type == 'result')
                                                <div class="w-10 h-10 rounded-full bg-yellow-100 flex items-center justify-center text-yellow-600 font-bold">🏆</div>
                                            @else
                                                <div class="w-10 h-10 rounded-full bg-gray-100 flex items-center justify-center text-gray-600 font-bold">📄</div>
                                            @endif
                                        </div>

                                        <div>
                                            <a href="{{ route('post.detail', $post->slug) }}" class="text-lg md:text-xl font-bold text-gray-800 group-hover:text-red-700 leading-snug transition">
                                                {{ $post->title }}
                                            </a>
                                            
                                            <div class="flex flex-wrap items-center gap-3 mt-2 text-sm text-gray-500">
                                                <span class="flex items-center gap-1 bg-gray-100 px-2 py-0.5 rounded text-xs font-medium border border-gray-200 uppercase">
                                                    {{ str_replace('_', ' ', $post->post_type) }}
                                                </span>
                                                <span class="flex items-center gap-1 bg-gray-50 px-2 py-0.5 rounded text-xs border border-gray-200">
                                                    📅 {{ $post->updated_at->format('d M, Y') }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <a href="{{ route('post.detail', $post->slug) }}" class="self-start md:self-center whitespace-nowrap px-5 py-2.5 bg-white border border-red-600 text-red-700 text-sm font-bold rounded-lg hover:bg-red-600 hover:text-white transition shadow-sm flex items-center gap-2 group-hover:shadow-md">
                                    View Details 
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 transition-transform group-hover:translate-x-1" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" /></svg>
                                </a>
                            </div>
                        </div>
                        @empty
                        <div class="p-16 text-center">
                            <div class="bg-red-50 w-24 h-24 rounded-full flex items-center justify-center mx-auto mb-4 border border-red-100">
                                <svg class="w-10 h-10 text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path></svg>
                            </div>
                            <h3 class="text-xl font-bold text-gray-800">No Matches Found</h3>
                            <p class="text-gray-500 mt-2 max-w-md mx-auto">We couldn't find any posts matching <span class="font-bold text-gray-700">"{{ $query }}"</span>. Try searching for generic terms like "Police", "Railway", or "SSC".</p>
                            
                            <div class="mt-6 flex justify-center gap-3">
                                <a href="{{ route('home') }}" class="px-6 py-2 bg-gray-800 text-white rounded-lg hover:bg-gray-700 transition font-bold">Go Home</a>
                                <a href="{{ route('view.all', 'job') }}" class="px-6 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition font-bold">Browse Jobs</a>
                            </div>
                        </div>
                        @endforelse
                    </div>

                    <div class="p-4 bg-gray-50 border-t border-gray-200">
                        {{ $posts->appends(['query' => $query])->links() }} 
                    </div>
                </div>

                <div class="mt-8">
                    <div class="ad-slot h-24">
                        📢 ADVERTISEMENT (Bottom)
                    </div>
                </div>
            </div>

            <div class="hidden lg:block space-y-6">
                <div class="ad-slot h-64">
                     📢 ADVERTISEMENT (Sidebar)
                </div>

                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    <div class="bg-gradient-to-r from-gray-800 to-gray-700 text-white p-3 font-bold text-center">
                        Quick Links
                    </div>
                    <div class="flex flex-col divide-y divide-gray-100">
                        <a href="{{ route('view.all', 'job') }}" class="p-3 hover:bg-gray-50 text-sm font-medium text-gray-700 flex justify-between items-center transition">
                            <span>💼 All Jobs</span>
                            <span class="text-gray-400">›</span>
                        </a>
                        <a href="{{ route('view.all', 'admit_card') }}" class="p-3 hover:bg-gray-50 text-sm font-medium text-gray-700 flex justify-between items-center transition">
                            <span>👤 Admit Cards</span>
                            <span class="text-gray-400">›</span>
                        </a>
                        <a href="{{ route('view.all', 'result') }}" class="p-3 hover:bg-gray-50 text-sm font-medium text-gray-700 flex justify-between items-center transition">
                            <span>🏆 Results</span>
                            <span class="text-gray-400">›</span>
                        </a>
                    </div>
                </div>
            </div>

        </div>
    </div>

   <footer class="bg-[#00284d] text-white py-8 mt-12 border-t-4 border-yellow-500">
    <div class="container mx-auto px-4 text-center">
        
        <div class="flex flex-wrap justify-center gap-4 mb-6 text-sm font-medium text-gray-300">
            <a href="{{ route('page.show', 'about-us') }}" class="hover:text-yellow-400 transition">About Us</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'contact-us') }}" class="hover:text-yellow-400 transition">Contact Us</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'privacy-policy') }}" class="hover:text-yellow-400 transition">Privacy Policy</a>
            <span class="text-gray-600">|</span>
            <a href="{{ route('page.show', 'disclaimer') }}" class="hover:text-yellow-400 transition">Disclaimer</a>
        </div>

        <p class="opacity-80">{!! get_setting('footer_text', '&copy; 2026 Job Update Portal. All rights reserved.') !!}</p>
    </div>
</footer>
</body>
</html>