<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $page->title }} - {{ get_setting('site_title') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Mukta:wght@400;500;600;700&family=Roboto:wght@400;500;700;900&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Roboto', sans-serif; background-color: #f8f9fa; }
        .hindi-text { font-family: 'Mukta', sans-serif; }
        
        /* Gradient for Hero Section */
        .page-header-bg { background: linear-gradient(135deg, #1e3a8a 0%, #172554 100%); }

        /* --- Content Typography (Rich Text Styling) --- */
        .prose { color: #334155; line-height: 1.75; }
        .prose h2 { font-size: 1.75rem; font-weight: 700; color: #1e3a8a; margin-top: 2rem; margin-bottom: 1rem; border-bottom: 2px solid #e2e8f0; padding-bottom: 0.5rem; }
        .prose h3 { font-size: 1.4rem; font-weight: 600; color: #334155; margin-top: 1.5rem; margin-bottom: 0.75rem; }
        .prose p { margin-bottom: 1.25rem; font-size: 1.05rem; }
        .prose ul { list-style-type: disc; padding-left: 1.5rem; margin-bottom: 1.25rem; }
        .prose ol { list-style-type: decimal; padding-left: 1.5rem; margin-bottom: 1.25rem; }
        .prose li { margin-bottom: 0.5rem; }
        .prose a { color: #2563eb; text-decoration: underline; font-weight: 500; transition: color 0.2s; }
        .prose a:hover { color: #1d4ed8; }
        .prose blockquote { border-left: 4px solid #3b82f6; padding-left: 1rem; font-style: italic; color: #475569; background: #f1f5f9; padding: 1rem; border-radius: 0 0.5rem 0.5rem 0; margin-bottom: 1.5rem; }
        
        /* Table Styling inside Pages */
        .prose table { width: 100%; border-collapse: collapse; margin-bottom: 1.5rem; }
        .prose th, .prose td { border: 1px solid #cbd5e1; padding: 0.75rem; text-align: left; }
        .prose th { background-color: #f1f5f9; font-weight: 600; }

        /* AD PLACEHOLDER STYLE */
        .ad-slot {
            background-color: #e5e7eb; /* Gray-200 */
            border: 2px dashed #9ca3af; /* Gray-400 */
            display: flex;
            align-items: center;
            justify-content: center;
            color: #6b7280;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.05em;
            width: 100%;
            margin-bottom: 1.5rem;
            overflow: hidden;
            text-align: center;
            font-size: 0.8rem;
        }
    </style>
</head>
<body class="bg-gray-50 flex flex-col min-h-screen">

    <nav class="bg-[#0f172a] text-white shadow-lg sticky top-0 z-50 border-b border-blue-900">
        <div class="container mx-auto px-4 py-3 flex justify-between items-center">
            <a href="{{ route('home') }}" class="flex items-center gap-2 group">
                <div class="bg-white p-1 rounded-sm group-hover:rotate-3 transition">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-blue-900" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M6 6V5a3 3 0 013-3h2a3 3 0 013 3v1h2a2 2 0 012 2v3.57A22.952 22.952 0 0110 13a22.95 22.95 0 01-8-1.43V8a2 2 0 012-2h2zm2-1a1 1 0 011-1h2a1 1 0 011 1v1H8V5zm1 5a1 1 0 011-1h.01a1 1 0 110 2H10a1 1 0 01-1-1z" clip-rule="evenodd" />
                    </svg>
                </div>
                <span class="text-2xl font-black uppercase text-yellow-400 tracking-tighter">
                    JOB <span class="text-white">UPDATE</span>
                </span>
            </a>
            <a href="{{ route('home') }}" class="text-sm font-bold bg-blue-600 px-4 py-2 rounded-lg hover:bg-blue-500 transition shadow-md flex items-center gap-1">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" /></svg>
                Home
            </a>
        </div>
    </nav>

    <div class="page-header-bg text-white py-12 relative overflow-hidden shadow-md">
        <div class="absolute inset-0 opacity-10 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')]"></div>
        
        <div class="container mx-auto px-4 relative z-10 text-center">
            <nav class="flex justify-center text-sm text-blue-200 mb-3">
                <a href="{{ route('home') }}" class="hover:text-white transition">Home</a>
                <span class="mx-2">/</span>
                <span class="text-white font-medium">{{ $page->title }}</span>
            </nav>
            <h1 class="text-4xl md:text-5xl font-extrabold uppercase tracking-wide drop-shadow-md">
                {{ $page->title }}
            </h1>
            <p class="mt-3 text-blue-100 max-w-2xl mx-auto opacity-90">
                Last Updated: <span class="font-semibold text-yellow-300">{{ $page->updated_at->format('d M, Y') }}</span>
            </p>
        </div>
    </div>

    <div class="container mx-auto px-4 mt-8">
        <div class="ad-slot h-24">
            📢 ADVERTISEMENT (Page Top)
        </div>
    </div>

    <div class="container mx-auto px-4 py-6 flex-grow">
        <div class="grid grid-cols-1 lg:grid-cols-4 gap-8">
            
            <div class="lg:col-span-3">
                
                <div class="ad-slot h-20 mb-6">
                    📢 ADVERTISEMENT (Before Content)
                </div>

                <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
                    
                    <div class="h-1 bg-gradient-to-r from-blue-500 via-purple-500 to-pink-500"></div>

                    <div class="p-8 md:p-10">
                        <div class="prose max-w-none">
                            {!! $page->content !!}
                        </div>
                    </div>

                    <div class="bg-gray-50 px-8 py-4 border-t border-gray-100 text-sm text-gray-500 flex justify-between items-center">
                        <span>&copy; {{ date('Y') }} {{ get_setting('site_title') }}</span>
                        <a href="{{ route('home') }}" class="text-blue-600 hover:underline">Back to Home</a>
                    </div>
                </div>

                <div class="ad-slot h-24 mt-6">
                    📢 ADVERTISEMENT (After Content)
                </div>

            </div>

            <div class="hidden lg:block space-y-6">
                
                <div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
                    <div class="bg-[#0f172a] text-white p-4 font-bold text-lg flex items-center gap-2">
                        <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                        Company Info
                    </div>
                    <div class="flex flex-col">
                        <a href="{{ route('page.show', 'about-us') }}" class="p-3 border-b hover:bg-blue-50 text-gray-700 font-medium flex justify-between items-center transition {{ request()->is('*about-us*') ? 'bg-blue-50 text-blue-700 border-l-4 border-l-blue-600' : '' }}">
                            <span>About Us</span>
                            <span class="text-gray-400">›</span>
                        </a>
                        <a href="{{ route('page.show', 'contact-us') }}" class="p-3 border-b hover:bg-blue-50 text-gray-700 font-medium flex justify-between items-center transition {{ request()->is('*contact-us*') ? 'bg-blue-50 text-blue-700 border-l-4 border-l-blue-600' : '' }}">
                            <span>Contact Us</span>
                            <span class="text-gray-400">›</span>
                        </a>
                        <a href="{{ route('page.show', 'privacy-policy') }}" class="p-3 border-b hover:bg-blue-50 text-gray-700 font-medium flex justify-between items-center transition {{ request()->is('*privacy-policy*') ? 'bg-blue-50 text-blue-700 border-l-4 border-l-blue-600' : '' }}">
                            <span>Privacy Policy</span>
                            <span class="text-gray-400">›</span>
                        </a>
                        <a href="{{ route('page.show', 'disclaimer') }}" class="p-3 hover:bg-blue-50 text-gray-700 font-medium flex justify-between items-center transition {{ request()->is('*disclaimer*') ? 'bg-blue-50 text-blue-700 border-l-4 border-l-blue-600' : '' }}">
                            <span>Disclaimer</span>
                            <span class="text-gray-400">›</span>
                        </a>
                    </div>
                </div>

                <div class="ad-slot h-64">
                    📢 ADVERTISEMENT (Sidebar)
                </div>

                <div class="bg-blue-600 rounded-xl shadow-lg p-6 text-white text-center">
                    <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center mx-auto mb-3">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path></svg>
                    </div>
                    <h4 class="font-bold text-lg mb-1">Need Help?</h4>
                    <p class="text-blue-100 text-sm mb-4">Have questions? Reach out to our support team.</p>
                    <a href="{{ route('page.show', 'contact-us') }}" class="inline-block bg-white text-blue-700 px-6 py-2 rounded-full font-bold hover:bg-gray-100 transition shadow-md">
                        Contact Support
                    </a>
                </div>

            </div>

        </div>
    </div>

    <footer class="bg-[#0f172a] text-blue-200 py-6 mt-auto text-center text-sm border-t border-blue-900">
        <div class="container mx-auto px-4">
            <p>&copy; {{ date('Y') }} {{ get_setting('site_title') }}. All rights reserved.</p>
            <div class="flex justify-center gap-4 mt-3 text-xs opacity-70">
                <a href="{{ route('page.show', 'privacy-policy') }}" class="hover:text-white">Privacy</a>
                <span>•</span>
                <a href="{{ route('page.show', 'disclaimer') }}" class="hover:text-white">Disclaimer</a>
            </div>
        </div>
    </footer>

</body>
</html>