@extends('admin.layout')
@section('header', 'All Posts')

@section('content')

<div class="bg-white rounded shadow-lg p-6">
    
    <div class="flex justify-between items-center mb-6">
        <form action="{{ route('admin.posts.index') }}" method="GET" class="flex gap-2">
            <input type="text" name="search" placeholder="Search by title..." value="{{ request('search') }}" class="border p-2 rounded w-64">
            <button type="submit" class="bg-gray-700 text-white px-4 py-2 rounded hover:bg-gray-800">Search</button>
        </form>

        <a href="{{ route('admin.posts.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 flex items-center gap-2">
            <i class="fas fa-plus"></i> Add New Post
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full border-collapse border border-gray-200">
            <thead>
                <tr class="bg-gray-100 text-left">
                    <th class="p-3 border">ID</th>
                    <th class="p-3 border">Title</th>
                    <th class="p-3 border">Type</th>
                    <th class="p-3 border">Category</th>
                    <th class="p-3 border">Status</th>
                    <th class="p-3 border text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($posts as $post)
                <tr class="hover:bg-gray-50 border-b">
                    <td class="p-3 border">{{ $post->id }}</td>
                    
                    <td class="p-3 border font-semibold text-gray-700">
                        {{Str::limit($post->title, 40) }}
                        <br>
                        <small class="text-gray-400">{{ $post->slug }}</small>
                    </td>
                    
                    <td class="p-3 border">
                        <span class="px-2 py-1 rounded text-xs font-bold 
                            {{ $post->post_type == 'job' ? 'bg-green-100 text-green-700' : '' }}
                            {{ $post->post_type == 'admit_card' ? 'bg-yellow-100 text-yellow-700' : '' }}
                            {{ $post->post_type == 'result' ? 'bg-red-100 text-red-700' : 'bg-gray-100 text-gray-600' }}">
                            {{ strtoupper(str_replace('_', ' ', $post->post_type)) }}
                        </span>
                    </td>
                    
                    <td class="p-3 border">{{ $post->category->name ?? 'No Category' }}</td>
                    
                    <td class="p-3 border">
                        @if($post->is_featured)
                            <span class="text-xs bg-purple-100 text-purple-600 px-2 py-1 rounded border border-purple-200">Featured</span>
                        @endif
                        @if($post->is_marquee)
                            <span class="text-xs bg-blue-100 text-blue-600 px-2 py-1 rounded border border-blue-200">Marquee</span>
                        @endif
                    </td>
                    
                    <td class="p-3 border text-center">
                        <div class="flex justify-center gap-2">
                            <a href="{{ route('admin.posts.edit', $post->id) }}" 
                               class="bg-blue-600 text-white px-3 py-1 rounded hover:bg-blue-700 text-sm flex items-center gap-1 transition">
                                ✏️ Edit
                            </a>

                            <a href="{{ route('admin.posts.delete', $post->id) }}" 
                               onclick="return confirm('Are you sure you want to delete this post?')" 
                               class="bg-red-600 text-white px-3 py-1 rounded hover:bg-red-700 text-sm flex items-center gap-1 transition">
                                🗑️ Delete
                            </a>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="mt-4">
        {{ $posts->links() }}
    </div>

</div>
@endsection