@extends('admin.layout')
@section('header', 'Edit Post')

@section('content')

<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

<div class="flex justify-between items-center mb-4">
    <h2 class="text-xl font-bold text-gray-800">Editing: {{ $post->title }}</h2>
    <a href="{{ route('admin.posts.index') }}" class="bg-gray-600 text-white px-4 py-2 rounded hover:bg-gray-700">
        <i class="fas fa-arrow-left"></i> Back to List
    </a>
</div>

<form action="{{ route('admin.posts.update', $post->id) }}" method="POST" class="bg-white p-6 rounded shadow-lg">
    @csrf
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        
        <div class="space-y-4">
            <div>
                <label class="block font-bold mb-1">Post Title *</label>
                <input type="text" name="title" id="title" value="{{ $post->title }}" class="w-full border p-2 rounded" required>
            </div>

            <div>
                <label class="block font-bold mb-1">Slug (URL) *</label>
                <input type="text" name="slug" id="slug" value="{{ $post->slug }}" class="w-full border p-2 rounded bg-gray-50" required readonly>
            </div>

            <div>
                <label class="block font-bold mb-1">Full Exam Name</label>
                <input type="text" name="post_name" value="{{ $post->post_name }}" class="w-full border p-2 rounded">
            </div>

            <div>
                <label class="block font-bold mb-1">Post Type</label>
                <select name="post_type" class="w-full border p-2 rounded">
                    <option value="job" {{ $post->post_type == 'job' ? 'selected' : '' }}>New Job</option>
                    <option value="admit_card" {{ $post->post_type == 'admit_card' ? 'selected' : '' }}>Admit Card</option>
                    <option value="result" {{ $post->post_type == 'result' ? 'selected' : '' }}>Result</option>
                    <option value="answer_key" {{ $post->post_type == 'answer_key' ? 'selected' : '' }}>Answer Key</option>
                    <option value="syllabus" {{ $post->post_type == 'syllabus' ? 'selected' : '' }}>Syllabus</option>
                    <option value="admission" {{ $post->post_type == 'admission' ? 'selected' : '' }}>Admission</option>
                </select>
            </div>

            <div>
                <label class="block font-bold mb-1">Category</label>
                <select name="category_id" class="w-full border p-2 rounded" required>
                    <option value="">Select Category</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}" {{ $post->category_id == $cat->id ? 'selected' : '' }}>
                            {{ $cat->name }}
                        </option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="space-y-4 border-l pl-4">
            <div class="flex items-center gap-2">
                <input type="checkbox" name="is_featured" id="feat" class="w-5 h-5" {{ $post->is_featured ? 'checked' : '' }}>
                <label for="feat" class="font-bold text-green-700">Show in Top Color Box? (Featured)</label>
            </div>
            
            <div class="flex items-center gap-2">
                <input type="checkbox" name="is_marquee" id="marq" class="w-5 h-5" {{ $post->is_marquee ? 'checked' : '' }}>
                <label for="marq" class="font-bold text-blue-700">Show in Scrolling Line? (Marquee)</label>
            </div>

            <div>
                <label class="block font-bold mb-1">Top Short Description</label>
                <textarea name="short_desc" rows="3" class="w-full border p-2 rounded">{{ $post->short_desc }}</textarea>
            </div>

             <div>
                <label class="block font-bold mb-1">Official Website Link</label>
                <input type="text" name="official_website" value="{{ $post->official_website }}" class="w-full border p-2 rounded">
            </div>
        </div>
    </div>

    <hr class="my-6 border-gray-300">

    <h3 class="text-xl font-bold mb-4 text-blue-800">Edit Details (Tables & Content)</h3>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label class="block font-bold mb-2 bg-yellow-100 p-1">1. Important Dates</label>
            <textarea name="dates_content" class="summernote">{!! $post->dates_content !!}</textarea>
        </div>
        <div>
            <label class="block font-bold mb-2 bg-yellow-100 p-1">2. Application Fee</label>
            <textarea name="fees_content" class="summernote">{!! $post->fees_content !!}</textarea>
        </div>
    </div>

    <div class="mt-6">
        <label class="block font-bold mb-2 bg-gray-100 p-1">3. Age Limit Details</label>
        <textarea name="age_content" class="summernote">{!! $post->age_content !!}</textarea>
    </div>

    <div class="mt-6">
        <label class="block font-bold mb-2 bg-green-100 p-1">4. Vacancy Details</label>
        <textarea name="vacancy_content" class="summernote">{!! $post->vacancy_content !!}</textarea>
    </div>

    <div class="mt-6">
        <label class="block font-bold mb-2 bg-red-100 p-1">5. Important Links</label>
        <textarea name="links_content" class="summernote">{!! $post->links_content !!}</textarea>
    </div>

    <div class="mt-8 text-center">
        <button type="submit" class="bg-blue-600 text-white font-bold py-3 px-8 rounded-lg hover:bg-blue-700 text-lg shadow">
            <i class="fas fa-save"></i> Update Post
        </button>
    </div>

</form>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>

<script>
    $(document).ready(function() {
        $('.summernote').summernote({
            height: 150,
            toolbar: [
                ['style', ['style', 'bold', 'italic', 'underline', 'clear']],
                ['font', ['color', 'fontsize']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture']],
                ['view', ['fullscreen', 'codeview']]
            ]
        });
    });

    // Auto Slug (Only if user changes title manually, otherwise keeps old slug)
    $('#title').on('keyup', function() {
        var title = $(this).val();
        var slug = title.toLowerCase()
                        .replace(/[^a-z0-9 -]/g, '')
                        .replace(/\s+/g, '-')
                        .replace(/-+/g, '-');
        $('#slug').val(slug);
    });
</script>

@endsection