@extends('admin.layout')
@section('header', 'All Static Pages')

@section('content')
<div class="bg-white rounded shadow-lg p-6">
    
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-xl font-bold">Pages List</h3>
        <a href="{{ route('admin.pages.create') }}" class="bg-blue-600 text-white px-4 py-2 rounded hover:bg-blue-700 flex items-center gap-2">
            <i class="fas fa-plus"></i> Add New Page
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full border-collapse border border-gray-200">
            <thead class="bg-gray-100">
                <tr>
                    <th class="p-3 border text-left">Title</th>
                    <th class="p-3 border text-left">Slug</th>
                    <th class="p-3 border text-center">Status</th>
                    <th class="p-3 border text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($pages as $page)
                <tr class="hover:bg-gray-50 border-b">
                    <td class="p-3 border font-semibold text-gray-700">{{ $page->title }}</td>
                    <td class="p-3 border text-gray-500">{{ $page->slug }}</td>
                    <td class="p-3 border text-center">
                        @if($page->status)
                            <span class="bg-green-100 text-green-700 px-2 py-1 rounded text-xs font-bold border border-green-200">Active</span>
                        @else
                            <span class="bg-red-100 text-red-700 px-2 py-1 rounded text-xs font-bold border border-red-200">Inactive</span>
                        @endif
                    </td>
                    
                    <td class="p-3 border text-center">
                        <div class="flex justify-center gap-2">
                            <a href="{{ route('admin.pages.edit', $page->id) }}" 
                               class="bg-blue-600 text-white px-3 py-1 rounded hover:bg-blue-700 text-sm flex items-center gap-1 transition">
                                ✏️ Edit
                            </a>
                            
                            <a href="{{ route('admin.pages.delete', $page->id) }}" 
                               onclick="return confirm('Delete this page?')" 
                               class="bg-red-600 text-white px-3 py-1 rounded hover:bg-red-700 text-sm flex items-center gap-1 transition">
                                🗑️ Delete
                            </a>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection