@extends('admin.layout')
@section('header', 'Edit Page')

@section('content')
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">

<form action="{{ route('admin.pages.update', $page->id) }}" method="POST" class="bg-white p-6 rounded shadow-lg max-w-4xl mx-auto">
    @csrf
    
    <div class="mb-4">
        <label class="block font-bold mb-1">Page Title</label>
        <input type="text" name="title" id="title" value="{{ $page->title }}" class="w-full border p-2 rounded" required>
    </div>

    <div class="mb-4">
        <label class="block font-bold mb-1">Slug (URL)</label>
        <input type="text" name="slug" id="slug" value="{{ $page->slug }}" class="w-full border p-2 rounded bg-gray-50" readonly required>
    </div>

    <div class="mb-6">
        <label class="block font-bold mb-1">Page Content</label>
        <textarea name="content" class="summernote">{!! $page->content !!}</textarea>
    </div>

    <div class="mb-6 flex items-center gap-2">
        <input type="checkbox" name="status" id="status" class="w-5 h-5" {{ $page->status ? 'checked' : '' }}>
        <label for="status" class="font-bold">Active?</label>
    </div>

    <button type="submit" class="bg-blue-600 text-white font-bold py-2 px-6 rounded hover:bg-blue-700">Update Page</button>
</form>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<script>
    $(document).ready(function() { $('.summernote').summernote({ height: 300 }); });
    $('#title').on('keyup', function() {
        var slug = $(this).val().toLowerCase().replace(/[^a-z0-9 -]/g, '').replace(/\s+/g, '-').replace(/-+/g, '-');
        $('#slug').val(slug);
    });
</script>
@endsection