<!DOCTYPE html>
<html lang="en">
<meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <title>@yield('meta_title', get_setting('site_title'))</title>
    
    <meta name="description" content="@yield('meta_description', get_setting('meta_description'))">

    <meta property="og:title" content="@yield('meta_title', get_setting('site_title'))" />
    <meta property="og:description" content="@yield('meta_description', get_setting('meta_description'))" />
    <meta property="og:image" content="@yield('meta_image', get_setting('site_logo'))" />
    
    <link rel="icon" href="{{ get_setting('favicon') }}" type="image/x-icon">
    
    {!! get_setting('header_script') !!}

    <script src="https://cdn.tailwindcss.com"></script>
    </head>
<body class="bg-gray-100 font-sans antialiased">

    <div class="flex h-screen">
        <aside class="w-64 bg-slate-800 text-white flex flex-col">
            <div class="p-4 text-2xl font-bold text-center border-b border-slate-700">
                Admin Panel
            </div>
            <nav class="flex-1 p-4 space-y-2">
                <a href="{{ route('admin.dashboard') }}" class="block p-3 rounded hover:bg-slate-700 {{ request()->routeIs('admin.dashboard') ? 'bg-blue-600' : '' }}">
                    <i class="fas fa-tachometer-alt w-6"></i> Dashboard
                </a>
                <a href="{{ route('admin.posts.index') }}" class="block p-3 rounded hover:bg-slate-700 {{ request()->routeIs('admin.posts.*') ? 'bg-blue-600' : '' }}">
                    <i class="fas fa-file-alt w-6"></i> All Posts
                </a>
               <a href="{{ route('admin.categories.index') }}" class="block p-3 rounded hover:bg-slate-700 {{ request()->routeIs('admin.categories.*') ? 'bg-blue-600' : '' }}">
    <i class="fas fa-list w-6"></i> Categories
</a>
<a href="{{ route('admin.pages.index') }}" class="block p-3 rounded hover:bg-slate-700 {{ request()->routeIs('admin.pages.*') ? 'bg-blue-600' : '' }}">
    <i class="fas fa-file w-6"></i> Static Pages
</a>
<a href="{{ route('admin.settings.index') }}" class="block p-3 rounded hover:bg-slate-700 {{ request()->routeIs('admin.settings.*') ? 'bg-blue-600' : '' }}">
    <i class="fas fa-cog w-6"></i> Settings
</a>
            </nav>
            <div class="p-4 border-t border-slate-700">
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" class="w-full text-left p-2 hover:text-red-400">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </button>
                </form>
            </div>
        </aside>

        <div class="flex-1 flex flex-col overflow-hidden">
            <header class="bg-white shadow p-4 flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-800">
                    @yield('header') </h2>
                <div class="text-gray-600">Hello, {{ Auth::user()->name ?? 'Admin' }}</div>
            </header>

            <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100 p-6">
                @if(session('success'))
                    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                        {{ session('success') }}
                    </div>
                @endif
                
                @yield('content') </main>
        </div>
    </div>

</body>
</html>