@extends('admin.layout')
@section('header', 'Manage Categories')

@section('content')

<div class="grid grid-cols-1 md:grid-cols-3 gap-6">

    <div class="bg-white p-6 rounded shadow-lg h-fit">
        <h3 class="text-lg font-bold mb-4 border-b pb-2">
            {{ isset($category) ? 'Edit Category' : 'Add New Category' }}
        </h3>

        <form action="{{ isset($category) ? route('admin.categories.update', $category->id) : route('admin.categories.store') }}" method="POST">
            @csrf
            
            <div class="mb-4">
                <label class="block font-bold mb-1">Category Name</label>
                <input type="text" name="name" id="name" 
                       value="{{ $category->name ?? '' }}" 
                       class="w-full border p-2 rounded focus:outline-blue-500" required>
            </div>

            <div class="mb-4">
                <label class="block font-bold mb-1">Slug (URL)</label>
                <input type="text" name="slug" id="slug" 
                       value="{{ $category->slug ?? '' }}" 
                       class="w-full border p-2 rounded bg-gray-100" readonly required>
            </div>

            <button type="submit" class="w-full text-white font-bold py-2 rounded 
                {{ isset($category) ? 'bg-yellow-600 hover:bg-yellow-700' : 'bg-blue-600 hover:bg-blue-700' }}">
                {{ isset($category) ? 'Update Category' : 'Add Category' }}
            </button>

            @if(isset($category))
                <a href="{{ route('admin.categories.index') }}" class="block text-center mt-2 text-gray-500 hover:underline">Cancel Edit</a>
            @endif
        </form>
    </div>

    <div class="md:col-span-2 bg-white p-6 rounded shadow-lg">
        <h3 class="text-lg font-bold mb-4 border-b pb-2">All Categories</h3>

        <div class="overflow-x-auto">
            <table class="w-full border text-left">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="p-3 border">Name</th>
                        <th class="p-3 border">Slug</th>
                        <th class="p-3 border text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    
                    @foreach($categories ?? $allCategories as $cat)
                    <tr class="border-b hover:bg-gray-50">
                        <td class="p-3 border font-semibold">{{ $cat->name }}</td>
                        <td class="p-3 border text-gray-500">{{ $cat->slug }}</td>
                        
                        <td class="p-3 border text-center">
                            <div class="flex justify-center gap-2">
                                <a href="{{ route('admin.categories.edit', $cat->id) }}" 
                                   class="bg-yellow-500 text-white px-3 py-1 rounded hover:bg-yellow-600 text-sm transition flex items-center gap-1">
                                    ✏️ Edit
                                </a>

                                <a href="{{ route('admin.categories.delete', $cat->id) }}" 
                                   onclick="return confirm('Delete this category?')" 
                                   class="bg-red-600 text-white px-3 py-1 rounded hover:bg-red-700 text-sm transition flex items-center gap-1">
                                    🗑️ Delete
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('#name').on('keyup', function() {
        var name = $(this).val();
        var slug = name.toLowerCase()
                        .replace(/[^a-z0-9 -]/g, '')
                        .replace(/\s+/g, '-')
                        .replace(/-+/g, '-');
        $('#slug').val(slug);
    });
</script>

@endsection