<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up()
{
    Schema::create('posts', function (Blueprint $table) {
        $table->id();
        // Relationship
        $table->foreignId('category_id')->constrained()->onDelete('cascade'); 
        
        // Basic Info
        $table->string('title'); 
        $table->string('post_name')->nullable(); // Example: "UP Police Constable Recruitment 2025"
        $table->string('slug')->unique();
        $table->text('short_desc')->nullable(); // Top par dikhane ke liye summary
        $table->text('short_info')->nullable(); // Brief intro
        
        // Flexible Content Areas (HTML support)
        $table->longText('dates_content')->nullable();     // Important Dates Table
        $table->longText('fees_content')->nullable();      // Application Fee Table
        $table->longText('age_content')->nullable();       // Age Limit Table
        $table->longText('vacancy_content')->nullable();   // Vacancy Details Table
        $table->longText('links_content')->nullable();     // Apply Online, Notification Links
        
        // Logic & Status (The "Flexible" Part)
        // Yahan se decide hoga ki ye Job hai ya Admit Card
        $table->enum('post_type', ['job', 'admit_card', 'result', 'answer_key', 'syllabus', 'admission'])->default('job'); 
        $table->boolean('status')->default(1);
        
        // Badges & Visibility
        $table->boolean('is_marquee')->default(0); // Scrolling line me dikhana hai?
        $table->boolean('is_featured')->default(0); // Top color box me dikhana hai?
        $table->date('last_updated')->nullable(); // Post update date
        
        // External Links (Optional direct links)
        $table->string('official_website')->nullable();
        $table->string('telegram_link')->nullable();
        
        // SEO Fields
        $table->string('meta_title')->nullable();
        $table->text('meta_desc')->nullable();
        $table->text('meta_keywords')->nullable();
        
        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('posts');
    }
};
