<?php

namespace App\Http\Controllers;

use App\Models\Post;
use App\Models\Page;
use Illuminate\Http\Request;

class SitemapController extends Controller
{
    public function index()
    {
        // 1. Static Posts (Jobs, Results, Admit Cards)
        $posts = Post::where('status', 1)
                     ->orderBy('updated_at', 'desc')
                     ->get();

        // 2. Static Pages (About, Contact, etc.)
        $staticPages = Page::where('status', 1)->get();

        // 3. Category/Archive Pages (Jo humne View All banaye thay)
        $categories = [
            'job', 'admit_card', 'result', 'answer_key', 'syllabus', 'admission'
        ];

        return response()->view('sitemap', [
            'posts' => $posts,
            'staticPages' => $staticPages,
            'categories' => $categories,
        ])->header('Content-Type', 'text/xml');
    }
}