<?php

use App\Models\Setting;
use Illuminate\Support\Facades\Cache;

if (!function_exists('get_setting')) {
    function get_setting($key, $default = null) {
        
        // 1. Cache Check (Baar baar DB query na ho)
        $value = Cache::rememberForever('setting_' . $key, function () use ($key) {
            $setting = Setting::where('key', $key)->first();
            return $setting ? $setting->value : null;
        });

        // 2. Agar value nahi mili database me, to Default return karo
        if (!$value) {
            return $default;
        }

        // 3. IMAGE FIX: Agar ye Logo ya Favicon hai, to pura URL bana kar do
        // Isse tumhare HTML me src="{{ get_setting('site_logo') }}" sahi chalega
        if ($key === 'site_logo' || $key === 'favicon') {
            return asset('storage/' . $value);
        }

        return $value;
    }
}